

<?php $__env->startSection('content'); ?>

<!-- Header Banner -->
<div class="banner-header valign bg-img bg-fixed" data-overlay-dark="5" data-background="<?php echo e(asset('storage/' . $siteSettings->breadcrumb)); ?>">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">
                <h6>
                    <div class="icon"><i class="flaticon-courthouse"></i></div> Who are we
                </h6>
                <h1><span>About</span> Lagos state law reform</h1>
            </div>
        </div>
    </div>
</div>
<!-- About -->
<section class="about section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 col-md-12 mb-30 animate-box" data-animate-effect="fadeInUp">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-courthouse"></i></div> About law firm
                </div>

                <p>The Lagos State Law Reform Commission (LAWRECOM) was established to ensure that the laws of Lagos State remain relevant, effective, and responsive to the needs of its citizens. As the cornerstone of legal development, we play a pivotal role in shaping a dynamic and modern legal framework.
                </p>
                <div class="section-title"><span>Our Core</span></div>
                <p>Our key responsibilities include:
                </p>
                <ul class="page-list list-unstyled mb-25">
                    <li>
                        <div class="page-list-icon"> <span class="ti-check"></span> </div>
                        <div class="page-list-text">
                            <p>Law Review: Continuously evaluating laws to identify areas for amendments, repeals, or new enactments.
                            </p>
                        </div>
                    </li>
                    <li>
                        <div class="page-list-icon"> <span class="ti-check"></span> </div>
                        <div class="page-list-text">
                            <p>Law Reform: Drafting reforms that address legal challenges and align with societal needs.
                            </p>
                        </div>
                    </li>
                    <li>
                        <div class="page-list-icon"> <span class="ti-check"></span> </div>
                        <div class="page-list-text">
                            <p>Codification: Simplifying and consolidating laws for clarity and accessibility.
                            </p>
                        </div>
                    </li>
                    <li>
                        <div class="page-list-icon"> <span class="ti-check"></span> </div>
                        <div class="page-list-text">
                            <p>Public Engagement: Actively involving the public, legal professionals, and stakeholders in the reform process.
                            </p>
                        </div>
                    </li>
                    <li>
                        <div class="page-list-icon"> <span class="ti-check"></span> </div>
                        <div class="page-list-text">
                            <p>Research and Analysis: Conducting thorough research to support evidence-based reforms and policy decisions.
                            </p>
                        </div>
                    </li>
                </ul>
            </div>
            <div class="col-lg-6 offset-lg-1 col-md-12 animate-box" data-animate-effect="fadeInUp">
                <div class="item">
                    <!-- <div class="year-box vert-move">
                        <div class="number">20</div>
                        <div class="txt">Years of experience</div>
                        <div class="number-bg"></div>
                    </div>  -->
                    <img src="<?php echo e(asset('storage/' . $siteSettings->about_banner)); ?>" class="img-fluid" alt="">
                    <br><br>
                    <img src="<?php echo e(asset('storage/' . $siteSettings->about_banner2)); ?>" class="img-fluid" alt="">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- About 2 -->
<section class="about section-padding bg-darkbrown">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-lg-5 col-md-12 animate-box" data-animate-effect="fadeInLeft"> <img class="img" src="<?php echo e(asset('storage/' . $siteSettings->mission_banner)); ?>" alt=""> </div>
            <div class="col-lg-5 offset-lg-1 col-md-12 animate-box" data-animate-effect="fadeInRight">
                <div class="section-subtitle text-white">
                    <div class="icon"><i class="flaticon-courthouse"></i></div> People make the difference
                </div>
                <!-- <div class="section-title white">We here for provide <span>legal consultancy</span></div> -->
                <p>At the Lagos State Law Reform Commission, our mission is to ignite positive change by transforming the legal landscape of Lagos State. We are committed to fostering a justice system that is transparent, accessible, and equitable for all. Through relentless reform and innovation, we strive to craft laws that e, promote inclusivity and societal growth, and align with global standards.</p>
                <!-- <div class="about-bottom mt-30"> <img src="img/signature.svg" alt="" class="image about-signature">
                    <div class="about-name-wrapper">
                        <div class="about-rol">President & Co-Founder</div>
                        <div class="about-name">Emily H. McGill</div>
                    </div>
                </div> -->
            </div>
        </div>
    </div>
</section>
<!-- Clients -->
<!-- <section class="clients section-padding">
    <div class="container">
        <div class="row">
            <div class="col-md-12 mb-30 text-center">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-courthouse"></i></div> Our Successes
                </div>
                <div class="section-title">Awards <span>&</span> Recognitions</div>
            </div>
        </div> -->
<!-- <div class="row justify-content-center">
            <div class="col-lg-7 col-md-12 text-center">
                <div class="owl-carousel owl-theme">
                    <div class="clients-logo">
                        <a href="#0"><img src="img/awards/01.png" alt=""></a>
                    </div>
                    <div class="clients-logo">
                        <a href="#0"><img src="img/awards/02.png" alt=""></a>
                    </div>
                    <div class="clients-logo">
                        <a href="#0"><img src="img/awards/03.png" alt=""></a>
                    </div>
                    <div class="clients-logo">
                        <a href="#0"><img src="img/awards/04.png" alt=""></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section> -->
<!-- Video -->
<!-- <section class="section-padding video-wrapper video bg-img bg-fixed" data-overlay-dark="5" data-background="img/slider/2.jpg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-12 text-center mb-20">
                <div class="section-subtitle text-white">
                    <div class="icon"><i class="flaticon-courthouse"></i></div> Watch law firm
                </div>
                <div class="section-title white">Law Firm <span>Promo Video</span></div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 text-center">
                <a class="vid" href="https://youtu.be/LK_Agkm-_wY">
                    <div class="vid-butn"> <span class="icon"><i class="ti-control-play"></i></span> </div>
                </a>
            </div>
        </div>
    </div>
</section> -->
<!-- Team -->
<section class="team section-padding">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center mb-20">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-courthouse"></i></div>
                    <div class="section-title">Meet Our <span>Board Members</span></div>
                </div>

            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="owl-carousel owl-theme">
                    <?php $__currentLoopData = $teamMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item">
                        <div class="img">
                            <img src="<?php echo e(asset('storage/' . $member->image)); ?>" alt="<?php echo e($member->name); ?>" class="img-cover">
                            <div class="social-icons">
                                <?php if($member->facebook): ?>
                                <a href="<?php echo e($member->facebook); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
                                <?php endif; ?>
                                <?php if($member->twitter): ?>
                                <a href="<?php echo e($member->twitter); ?>" target="_blank"><i class="fab fa-x-twitter"></i></a>
                                <?php endif; ?>
                                <?php if($member->instagram): ?>
                                <a href="<?php echo e($member->instagram); ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                                <?php endif; ?>
                                <?php if($member->linkedin): ?>
                                <a href="<?php echo e($member->linkedin); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="info">
                            <h5><a href="#"><?php echo e($member->name); ?></a></h5>
                            <p><?php echo e($member->role); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Get in touch -->
<section class="call">
    <div class="background bg-img bg-fixed section-padding" data-background="img/slider/12.jpg" data-overlay-dark="3">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-8 col-md-12">
                    <div class="section-title text-white mb-0">All people are equal before the law. <span>A good attorney</span> is what makes a difference.</div>
                </div>
                <div class="col-lg-3 offset-lg-1 col-md-12">
                    <div class="call-center">
                        <div class="icon"><i class="fa-solid fa-phone"></i></div>
                        <div class="text">
                            <p>Get in touch</p> <a href="tel:<?php echo e($siteSettings->contact_phone); ?>"><?php echo e($siteSettings->contact_phone); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Sellie Deals\Documents\lawreform\resources\views/about.blade.php ENDPATH**/ ?>