<?php

use App\Http\Controllers\AboutController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LawReformController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\PublicationController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\PublicEngagementController;
use App\Http\Controllers\ReformProjectController;
use App\Models\Publication;
use Illuminate\Support\Facades\Storage;

// Route::get('/', function () {
//     return view('welcome');
// });

// Route::get('/', 'HomeController@index')->name('home');
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/about', [AboutController::class, 'index'])->name('about');

Route::get('/news', [NewsController::class, 'index'])->name('news.index');
Route::get('/news/{news}', [NewsController::class, 'show'])->name('news.show');
// Law Reforms
Route::get('/law-reforms', [LawReformController::class, 'index'])->name('law-reforms.index');
Route::get('/law-reforms/{reform}', [LawReformController::class, 'show'])->name('law-reforms.show');

Route::get('/projects', [ReformProjectController::class, 'index'])->name('projects.index');
Route::get('/projects/{project}', [ReformProjectController::class, 'show'])->name('projects.show');

// Publications
Route::get('/publications', [PublicationController::class, 'index'])->name('publications.index');
Route::get('/downloads/{publication}', [PublicationController::class, 'download'])
    ->name('publications.download');

Route::get('/contact', [ContactController::class, 'index'])->name('contact');
Route::post('/contact', [ContactController::class, 'submit'])
    ->name('contact.submit');

Route::get('/public-engagement', [PublicEngagementController::class, 'index'])->name('public.engagement');
Route::post('/public-engagement/feedback', [PublicEngagementController::class, 'submitFeedback'])->name('public.feedback.submit');
// Route::post('/polls/{poll}/vote', [PublicEngagementController::class, 'voteOnPoll'])->name('public.poll.vote');
Route::post('/events/{event}/support', [PublicEngagementController::class, 'supportEvent'])->name('public.event.support');
Route::get('/public-engagement', [PublicEngagementController::class, 'index'])->name('public.engagement');
Route::post('/feedback', [PublicEngagementController::class, 'submitFeedback'])->name('public.feedback.submit');
Route::post('/memorandum', [PublicEngagementController::class, 'submitMemorandum'])->name('public.memorandum.submit');
Route::post('/polls/{poll}/vote', [PublicEngagementController::class, 'voteOnPoll'])->name('public.poll.vote');
Route::post('/events/{event}/support', [PublicEngagementController::class, 'supportEvent'])->name('public.event.support');
Route::post('/events/register', [PublicEngagementController::class, 'registerForEvent'])->name('public.event.register');
Route::get('/events/{event}', [EventController::class, 'show'])->name('public.event.details');
// Route::get('/publications/{publication}', [PublicationController::class, 'show'])->name('publications.show');
// Route::get('/contact', [ContactController::class, 'index'])->name('contact');
// Route::post('/contact', [ContactController::class, 'store'])->name('contact.store');
