@extends('layouts.app')

@section('content')
<!-- Header Banner -->
<div class="banner-header valign bg-img bg-fixed" data-overlay-dark="6" data-background="{{ asset('storage/' . $siteSettings->breadcrumb) }}">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">
                <!-- <h6>
                    <div class="icon"><i class="flaticon-book"></i></div> Research & Insights
                </h6> -->
                <h1>Legal <span>Publications</span></h1>
            </div>
        </div>
    </div>
</div>

<!-- Filter Bar -->
<section class="section-padding">
    <div class="container">
        <form method="GET" class="row align-items-end g-3 mb-5">
            <!-- <div class="col-md-5">
                <input type="text" name="search" class="form-control" placeholder="Search publications..." value="{{ request('search') }}">
            </div> -->
            <div class="col-md-3">
                <select name="type" class="form-select">
                    <option value="">All Types</option>
                    <option value="report" {{ request('type') == 'report' ? 'selected' : '' }}>Report</option>
                    <option value="brief" {{ request('type') == 'brief' ? 'selected' : '' }}>Brief</option>
                </select>
            </div>
            <div class="col-md-3">
                <select name="year" class="form-select" onchange="this.form.submit()">
                    <option value="">All Years</option>
                    @foreach($years as $year)
                    <option value="{{ $year }}" {{ request('year') == $year ? 'selected' : '' }}>{{ $year }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-1">
                <button type="submit" class="btn btn-dark w-100"><i class="fas fa-filter"></i></button>
            </div>
        </form>

        <!-- Publications Table -->
        <div class="table-responsive">
            <table class="table table-hover table-bordered bg-white shadow-sm">
                <thead class="table-dark">
                    <tr>
                        <th>Title</th>
                        <th>Type</th>
                        <th>Published</th>
                        <th>Download</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($publications as $pub)
                    <tr>
                        <td>
                            <strong>{{ $pub->title }}</strong><br>
                            <small class="text-muted">{{ Str::limit($pub->description, 80) }}</small>
                        </td>
                        <td>{{ ucfirst($pub->type) }}</td>
                        <td>{{ $pub->published_date->format('d M Y') }}</td>
                        <td>
                            <a href="{{ route('publications.download', $pub->id) }}" class="btn btn-outline-primary btn-sm">
                                <i class="fa fa-download me-1"></i> Download
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No publications found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="mt-4">
            {{ $publications->links('vendor.pagination.bootstrap-5') }}
        </div>
    </div>
</section>
@endsection