@extends('layouts.app')

@section('content')
<!-- Header Banner -->
<div class="banner-header valign bg-img bg-fixed" data-overlay-dark="5" data-background="{{ asset('storage/' . $siteSettings->breadcrumb) }}">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">

                <h1>Law Reform Projects</h1>
            </div>
        </div>
    </div>
</div>
<section class="blog section-padding bg-lightbrown">
    <div class="container">
        <div class="row">
            @foreach($projects as $project)
            <div class="col-md-4 mb-4">
                <a href="{{ route('projects.show', $project->id) }}" class="text-decoration-none text-dark">
                    <div class="card h-100 hover-shadow transition">
                        <div class="card-body">
                            <h5>{{ $project->title }}</h5>
                            <p><strong>Focus Area:</strong> {{ $project->focus_area }}</p>
                            <p><strong>Status:</strong> {{ $project->status }}</p>
                            <p>{{ \Illuminate\Support\Str::limit($project->description, 100) }}</p>
                            @if ($project->progress_report)
                            <span class="text-primary">📄 Download Report</span>
                            @endif
                        </div>
                    </div>
                </a>
            </div>
            @endforeach
        </div>
    </div>
</section>

@endsection