<footer class="footer">
    <!-- Top Section -->
    <div class="top">
        <div class="container">
            <div class="row">
                <!-- Logo Column -->
                <div class="col-md-4 mb-30">
                    <div class="item">
                        <div class="logo">
                            <img src="{{ asset('storage/' . $siteSettings->logo) }}" alt="{{ $siteSettings->site_name }}">
                        </div>
                        <p>We are building a more inclusive, just, and forward-thinking legal system. One reform at a time. We are dedicated to:
                            Conducting systematic reviews of existing laws to identify gaps, inconsistencies, and areas in need of reform.
                            Repealing obsolete and redundant statutes to maintain a relevant legal framework.
                        </p>
                        <div class="social-icons">
                            <ul class="list-inline">
                                <li>
                                    <a href="{{ $siteSettings->linkedin_link }}" class="text-decoration-none" target="_blank" rel="noopener noreferrer">
                                        <i class="fa-brands fa-linkedin-in"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ $siteSettings->twitter_link }}" class="text-decoration-none" target="_blank" rel="noopener noreferrer">
                                        <i class="fa-brands fa-x-twitter"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ $siteSettings->facebook_link }}" class="text-decoration-none" target="_blank" rel="noopener noreferrer">
                                        <i class="fa-brands fa-facebook-f"></i>
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Contact Column -->
                <div class="col-md-3 offset-md-1 mb-30">
                    <div class="item">
                        <h3>Contact</h3>
                        <p>{{ $siteSettings->contact_address }}</p>
                        <div class="phone mb-0">
                            <a href="tel:{{ $siteSettings->contact_phone }}" class="text-decoration-none">{{ $siteSettings->contact_phone }}</a>
                        </div>
                        <div class="mail">
                            <a href="mailto:{{ $siteSettings->contact_email }}" class="text-decoration-none">
                                {{ $siteSettings->contact_email }}
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Newsletter Column -->
                <div class="col-md-4 mb-30">
                    <div class="item">
                        <h3>Subscribe</h3>
                        <p>Want to be notified about our services. Sign up and we'll send you a notification by email.</p>
                        <div class="newsletter">
                            <form action="" method="POST">
                                @csrf
                                <div class="input-group">
                                    <input type="email" name="email" class="form-control" placeholder="Email Address" required>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa-light fa-arrow-right"></i>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bottom Section -->
    <div class="bottom">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 col-md-12">
                    <div class="links">
                        <ul class="list-inline mb-0">
                            <li class="list-inline-item"><a href="{{ route('home') }}" class="text-decoration-none">Home</a></li>
                            <li class="list-inline-item"><a href="{{ route('about') }}" class="text-decoration-none">About</a></li>
                            <li class="list-inline-item"><a href="{{ route('projects.index') }}" class="text-decoration-none">Law Reforms</a></li>
                            <li class="list-inline-item"><a href="{{ route('publications.index') }}" class="text-decoration-none">News</a></li>
                            <li class="list-inline-item"><a href="{{ route('contact') }}" class="text-decoration-none">Contact</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4 col-md-12 text-lg-end">
                    <p class="mb-0">
                        Copyright &copy; {{ date('Y') }} by
                        <a href="#" class="text-decoration-none">{{ $siteSettings->site_name }}</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</footer>