@extends('layouts.app')

@section('content')
<!-- Header Banner -->
<section class="banner-header valign bg-img bg-fixed" data-overlay-dark="5" data-background="{{ asset('storage/' . $siteSettings->breadcrumb) }}">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">
                <h1 class="display-5 fw-bold">Latest News & Media</h1>
            </div>
        </div>
    </div>
</section>



<!-- News Detail Section -->
<section class="py-5">
    <div class="container">
        <div class="row g-5">
            <!-- Main Content -->
            <main class="col-lg-8">
                <article class="news-article" data-aos="fade-up">
                    <!-- Article Header -->
                    <header class="mb-5">
                        <div class="mb-3">
                            @if($news->category)
                            <span class="badge fs-6 px-3 py-2 rounded-pill" style="background-color: #905424;">
                                {{ $news->category->name }}
                            </span>
                            @endif
                        </div>

                        <h1 class="display-4 font-display fw-bold mb-4 lh-sm">{{ $news->title }}</h1>

                        <div class="d-flex flex-wrap align-items-center text-muted mb-4">
                            <div class="d-flex align-items-center me-4 mb-2">
                                <i class="bi bi-person-circle me-2"></i>
                                <span>{{ $news->user->name ?? 'Admin' }}</span>
                            </div>
                            <div class="d-flex align-items-center me-4 mb-2">
                                <i class="bi bi-calendar3 me-2"></i>
                                <time datetime="{{ $news->created_at->toISOString() }}">Published
                                    {{ $news->created_at->format('F j, Y') }}
                                </time>
                            </div>
                            <!-- <div class="d-flex align-items-center me-4 mb-2">
                                <i class="bi bi-clock me-2"></i>
                                <span>{{ $news->read_time ?? '5' }} min read</span>
                            </div> -->
                            @if($news->updated_at->gt($news->created_at))
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-pencil-square me-2"></i>
                                <small>Last Updated {{ $news->updated_at->format('M j, Y') }}</small>
                            </div>
                            @endif
                        </div>

                        <!-- Social Share -->
                        <div class="d-flex align-items-center gap-2 mb-4">
                            <span class="text-muted me-2">Share:</span>

                            <a href="https://twitter.com/intent/tweet?url={{ urlencode(request()->url()) }}&text={{ urlencode($news->title) }}"
                                target="_blank"
                                class="btn btn-sm me-1"
                                style="color: #1DA1F2; border: 1px solid #1DA1F2;"
                                aria-label="Share on Twitter">
                                <i class="bi bi-twitter"></i>
                            </a>

                            <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(request()->url()) }}"
                                target="_blank"
                                class="btn btn-sm me-1"
                                style="color: #1877F2; border: 1px solid #1877F2;"
                                aria-label="Share on Facebook">
                                <i class="bi bi-facebook"></i>
                            </a>

                            <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode(request()->url()) }}"
                                target="_blank"
                                class="btn btn-sm"
                                style="color: #0077B5; border: 1px solid #0077B5;"
                                aria-label="Share on LinkedIn">
                                <i class="bi bi-linkedin"></i>
                            </a>
                            <button class="btn btn-outline-primary btn-sm" onclick="copyToClipboard('{{ request()->url() }}')" aria-label="Copy link">
                                <i class="bi bi-link-45deg"></i>
                            </button>
                        </div>
                    </header>

                    <!-- Featured Image -->
                    @if($news->image)
                    <figure class="mb-5" data-aos="fade-up" data-aos-delay="100">
                        <img src="{{ asset('storage/' . $news->image) }}"
                            class="img-fluid rounded-3 w-100"
                            alt="{{ $news->title }}"
                            style="max-height: 500px; object-fit: cover;">
                        @if($news->image_caption)
                        <figcaption class="text-muted mt-2 small">{{ $news->image_caption }}</figcaption>
                        @endif
                    </figure>
                    @endif

                    <!-- Article Content -->
                    <div class="article-content fs-5 lh-lg" data-aos="fade-up" data-aos-delay="200">
                        {!! $news->content !!}
                    </div>

                    <!-- Image Gallery -->
                    @if($news->images && count($news->images) > 0)
                    <section class="mt-5" data-aos="fade-up" data-aos-delay="300">
                        <h3 class="h4 font-display mb-4">Photo Gallery</h3>
                        <div class="row g-3">
                            @foreach($news->images as $index => $image)
                            <div class="col-md-4 col-6">
                                <a href="#"
                                    data-bs-toggle="modal"
                                    data-bs-target="#galleryModal"
                                    data-image-index="{{ $index }}"
                                    class="gallery-item d-block">
                                    <img src="{{ asset('storage/' . $image) }}"
                                        class="img-fluid rounded-3 w-100"
                                        alt="Gallery Image {{ $index + 1 }}"
                                        style="height: 200px; object-fit: cover;">
                                </a>
                            </div>
                            @endforeach
                        </div>
                    </section>
                    @endif

                    <!-- Video -->
                    @if($news->video_url)
                    <section class="mt-5" data-aos="fade-up" data-aos-delay="400">
                        <h3 class="h4 font-display mb-4">Video</h3>
                        <div class="ratio ratio-16x9 rounded-3 overflow-hidden">
                            <iframe src="{{ $news->video_url }}"
                                frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen
                                title="Video for {{ $news->title }}">
                            </iframe>
                        </div>
                    </section>
                    @endif

                    <!-- Tags -->
                    @if($news->tags && count($news->tags) > 0)
                    <section class="mt-5" data-aos="fade-up" data-aos-delay="500">
                        <h4 class="h6 text-muted mb-3">Tags:</h4>
                        <div class="d-flex flex-wrap gap-2">
                            @foreach($news->tags as $tag)
                            <a href="{{ route('news.index', ['tag' => $tag]) }}"
                                class="badge bg-light text-dark text-decoration-none px-3 py-2 rounded-pill">
                                #{{ $tag }}
                            </a>
                            @endforeach
                        </div>
                    </section>
                    @endif
                </article>

                <!-- Article Navigation -->
                <nav class="mt-5 pt-5 border-top" data-aos="fade-up" data-aos-delay="600">
                    <div class="row g-4">
                        @if($previous)
                        <div class="col-md-6">
                            <a href="{{ route('news.show', $previous->slug ?? $previous->id) }}"
                                class="card h-100 text-decoration-none">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="bi bi-arrow-left me-2"></i>
                                        <small class="text-muted">Previous Article</small>
                                    </div>
                                    <h5 class="card-title">{{ Str::limit($previous->title, 60) }}</h5>
                                </div>
                            </a>
                        </div>
                        @endif

                        @if($next)
                        <div class="col-md-6 {{ !$previous ? 'ms-auto' : '' }}">
                            <a href="{{ route('news.show', $next->slug ?? $next->id) }}"
                                class="card h-100 text-decoration-none">
                                <div class="card-body text-end">
                                    <div class="d-flex align-items-center justify-content-end mb-2">
                                        <small class="text-muted">Next Article</small>
                                        <i class="bi bi-arrow-right ms-2"></i>
                                    </div>
                                    <h5 class="card-title">{{ Str::limit($next->title, 60) }}</h5>
                                </div>
                            </a>
                        </div>
                        @endif
                    </div>

                    <div class="text-center mt-4">
                        <a href="{{ route('news.index') }}" class="btn btn-outline-primary">
                            <i class="bi bi-grid me-2"></i>View All Articles
                        </a>
                    </div>
                </nav>
            </main>

            <!-- Sidebar -->
            <aside class="col-lg-4">
                <!-- Latest News -->
                <div class="card mb-4" data-aos="fade-up" data-aos-delay="300">
                    <div class="card-header bg-white border-0 pb-0">
                        <h3 class="h5 font-display mb-0">Latest News</h3>
                    </div>
                    <div class="card-body">
                        @forelse($latestNews as $latest)
                        <article class="d-flex mb-3 {{ !$loop->last ? 'pb-3 border-bottom' : '' }}">
                            @if($latest->image)
                            <div class="flex-shrink-0 me-3">
                                <img src="{{ asset('storage/' . $latest->image) }}"
                                    class="rounded"
                                    width="80"
                                    height="60"
                                    style="object-fit: cover;"
                                    alt="{{ $latest->title }}">
                            </div>
                            @endif
                            <div class="flex-grow-1">
                                <h4 class="h6 mb-1">
                                    <a href="{{ route('news.show', $latest->slug ?? $latest->id) }}"
                                        class="text-decoration-none text-dark">
                                        {{ Str::limit($latest->title, 50) }}
                                    </a>
                                </h4>
                                <small class="text-muted">
                                    <time datetime="{{ $latest->created_at->toISOString() }}">
                                        {{ $latest->created_at->format('M j, Y') }}
                                    </time>
                                </small>
                            </div>
                        </article>
                        @empty
                        <p class="text-muted">No recent news available.</p>
                        @endforelse
                    </div>
                </div>

                <!-- Categories -->
                <div class="card mb-4" data-aos="fade-up" data-aos-delay="400">
                    <div class="card-header bg-white border-0 pb-0">
                        <h3 class="h5 font-display mb-0">Categories</h3>
                    </div>
                    <div class="card-body">
                        @forelse($categories as $category)
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <a href="{{ route('news.index', ['category' => $category->id]) }}"
                                class="text-decoration-none">
                                {{ $category->name }}
                            </a>
                            <span class="badge bg-light text-dark">{{ $category->news_count ?? 0 }}</span>
                        </div>
                        @empty
                        <p class="text-muted">No categories available.</p>
                        @endforelse
                    </div>
                </div>


            </aside>
        </div>
    </div>
</section>

<!-- Gallery Modal -->
@if($news->images && count($news->images) > 0)
<div class="modal fade" id="galleryModal" tabindex="-1" aria-labelledby="galleryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title" id="galleryModalLabel">Gallery</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div id="galleryCarousel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        @foreach($news->images as $index => $image)
                        <div class="carousel-item {{ $index === 0 ? 'active' : '' }}">
                            <img src="{{ asset('storage/' . $image) }}"
                                class="d-block w-100"
                                alt="Gallery Image {{ $index + 1 }}">
                        </div>
                        @endforeach
                    </div>
                    @if(count($news->images) > 1)
                    <button class="carousel-control-prev" type="button" data-bs-target="#galleryCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Previous</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#galleryCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Next</span>
                    </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection

@push('styles')
<style>
    .article-content {
        font-size: 1.125rem;
        line-height: 1.8;
    }

    .article-content h2,
    .article-content h3,
    .article-content h4 {
        font-family: 'Playfair Display', serif;
        margin-top: 2rem;
        margin-bottom: 1rem;
    }

    .article-content p {
        margin-bottom: 1.5rem;
    }

    .article-content img {
        max-width: 100%;
        height: auto;
        border-radius: 0.5rem;
        margin: 1.5rem 0;
    }

    .gallery-item {
        transition: transform 0.3s ease;
        cursor: pointer;
    }

    .gallery-item:hover {
        transform: scale(1.05);
    }

    .newsletter-form .form-control:focus {
        border-color: rgba(255, 255, 255, 0.5);
        box-shadow: 0 0 0 0.2rem rgba(255, 255, 255, 0.25);
    }
</style>
@endpush

@push('scripts')
<script>
    // Copy to clipboard function
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(function() {
            // Show success message
            const toast = document.createElement('div');
            toast.className = 'toast align-items-center text-white bg-success border-0 position-fixed top-0 end-0 m-3';
            toast.setAttribute('role', 'alert');
            toast.innerHTML = `
                <div class="d-flex">
                    <div class="toast-body">Link copied to clipboard!</div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                </div>
            `;
            document.body.appendChild(toast);
            const bsToast = new bootstrap.Toast(toast);
            bsToast.show();

            // Remove toast after it's hidden
            toast.addEventListener('hidden.bs.toast', function() {
                document.body.removeChild(toast);
            });
        });
    }

    // Gallery modal functionality
    document.addEventListener('DOMContentLoaded', function() {
        const galleryItems = document.querySelectorAll('.gallery-item');
        const galleryModal = document.getElementById('galleryModal');
        const galleryCarousel = document.getElementById('galleryCarousel');

        if (galleryModal && galleryCarousel) {
            galleryItems.forEach((item) => {
                item.addEventListener('click', function(e) {
                    e.preventDefault();
                    const imageIndex = parseInt(this.getAttribute('data-image-index'));

                    // Wait for modal to be shown, then navigate to the correct slide
                    galleryModal.addEventListener('shown.bs.modal', function() {
                        const carousel = bootstrap.Carousel.getOrCreateInstance(galleryCarousel);
                        carousel.to(imageIndex);
                    }, {
                        once: true
                    });
                });
            });
        }

        // Newsletter form submission
        const newsletterForm = document.querySelector('.newsletter-form');
        if (newsletterForm) {
            newsletterForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const formData = new FormData(this);
                const submitBtn = this.querySelector('button[type="submit"]');
                const originalContent = submitBtn.innerHTML;

                submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i>';
                submitBtn.disabled = true;

                fetch(this.action, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            this.reset();
                            showToast('Successfully subscribed to newsletter!', 'success');
                        } else {
                            showToast('Error subscribing to newsletter. Please try again.', 'error');
                        }
                    })
                    .catch(error => {
                        showToast('Error subscribing to newsletter. Please try again.', 'error');
                    })
                    .finally(() => {
                        submitBtn.innerHTML = originalContent;
                        submitBtn.disabled = false;
                    });
            });
        }
    });

    function showToast(message, type) {
        const bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        const toast = document.createElement('div');
        toast.className = `toast align-items-center text-white ${bgClass} border-0 position-fixed top-0 end-0 m-3`;
        toast.setAttribute('role', 'alert');
        toast.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">${message}</div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        `;
        document.body.appendChild(toast);
        const bsToast = new bootstrap.Toast(toast);
        bsToast.show();

        toast.addEventListener('hidden.bs.toast', function() {
            document.body.removeChild(toast);
        });
    }
</script>
@endpush