@extends('layouts.app')

@section('content')


<!-- Header Banner -->
<div class="banner-header valign bg-img bg-fixed" data-overlay-dark="6" data-background="{{ asset('storage/' . $siteSettings->breadcrumb) }}">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">
                <h6>
                    <h1>Latest <span>News/Media</span></h1>
                </h6>

            </div>
        </div>
    </div>
</div>

<!-- Blog Section -->
<section class="blog section-padding bg-lightbrown">
    <div class="container">
        <div class="row">
            @foreach($news as $item)
            <div class="col-lg-4 col-md-6 d-flex">
                <div class="item mt-10 mb-30 w-100">
                    <div class="img">
                        <a href="{{ route('news.show', $item->id) }}">
                            @if($item->images && count($item->images) > 0)
                            <img src="{{ asset('storage/'.$item->images[0]) }}"
                                class="img-fluid"
                                alt="{{ $item->title }}"
                                style="height: 250px; object-fit: cover;">
                            @else
                            <div class="bg-secondary d-flex align-items-center justify-content-center"
                                style="height: 250px;">
                                <i class="fas fa-image fa-3x text-light"></i>
                            </div>
                            @endif

                            <div class="cat">{{ $item->category->name ?? 'General' }}</div>
                        </a>
                    </div>
                    <div class="cont">
                        <h4><a href="{{ route('news.show', $item->id) }}">{!! Str::limit(strip_tags($item->title), 50) !!}</a></h4>
                        <p>{!! Str::limit(strip_tags($item->content), 100) !!}</p>
                        <div class="author">
                            <div>
                                <h5>{{ $item->created_at->diffForHumans() }}</h5>
                                <h5>by <a href="#" class="text-decoration-line-bottom">{{ $item->user->name ?? 'Admin' }}</a></h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>


    <!-- Pagination -->
    <div class="row">
        <div class="col-md-12 text-center mt-30">
            {{ $news->links('vendor.pagination.custom') }}
        </div>
    </div>
    </div>
</section>
@endsection