@extends('layouts.app')

@section('content')
<!-- Header Banner -->
<div class="banner-header valign bg-img bg-fixed" data-overlay-dark="6" data-background="{{ asset('storage/' . $siteSettings->breadcrumb) }}">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">
                <h6>
                    <div class="icon"><i class="flaticon-courthouse"></i></div> Legal Reforms
                </h6>
                <h1>Law <span>Reforms</span></h1>
            </div>
        </div>
    </div>
</div>

<!-- Law Reforms Section -->
<section class="case-study section-padding">
    <div class="container">
        <div class="row">
            @foreach($reforms as $reform)
            <div class="col-lg-4 col-md-6 mb-30">
                <div class="item">
                    <div class="img">
                        @if($reform->image)
                        <img src="{{ asset('storage/'.$reform->image) }}" alt="{{ $reform->title }}">
                        @else
                        <img src="{{ asset('img/placeholder.png') }}" alt="Law Reform Placeholder">
                        @endif
                    </div>
                    <div class="con">
                        <div class="title">{{ $reform->title }}</div>
                        <div class="meta">
                            <span><i class="far fa-calendar"></i> {{ $reform->effective_date->format('M d, Y') }}</span>
                            <span><i class="far fa-file-pdf"></i> PDF</span>
                        </div>
                        <div class="arrow">
                            <a href="{{ route('law-reforms.show', $reform) }}">
                                <span>View Details</span>
                                <i class="fa-light fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        @if($reforms->hasPages())
        <div class="row mt-50">
            <div class="col-md-12 text-center">
                {{ $reforms->links() }}
            </div>
        </div>
        @endif
    </div>
</section>

<!-- FAQ Section -->
<section class="section-padding bg-lightbrown">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center mb-20">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-courthouse"></i></div> Reform Questions
                </div>
                <div class="section-title">Frequently Asked <span>Questions</span></div>
            </div>
        </div>
        <div class="row">
            <!-- FAQ content same as before -->
        </div>
    </div>
</section>
@endsection