@extends('layouts.app')

@section('content')
<style>
    :root {
        --primary: rgb(129, 94, 6);
        --secondary: rgb(129, 94, 6);
        --accent: rgb(129, 94, 6);
        --light: #f8f9fa;
        --dark: #212529;
    }

    .btn-primary {
        background: var(--primary);
        border: none;
        padding: 10px 25px;
        font-weight: 600;
        transition: all 0.3s;
    }

    .card-header {
        background: var(--primary);
        color: white;
        font-weight: 600;
        padding: 15px 20px;
    }
</style>
<!-- Header Banner -->
<div class="banner-header valign bg-img bg-fixed" data-overlay-dark="5" data-background="{{ $event->image_path ? asset('storage/' . $event->image_path) : asset('storage/' . $siteSettings->breadcrumb) }}">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">
                <h6>
                    <div class="icon"><i class="fas fa-calendar-day"></i></div> Event Details
                </h6>
                <h1>{{ $event->title }}</h1>
                <div class="mt-4">
                    <span class="badge card-header fs-5 px-4 py-2">
                        <i class="fas fa-calendar me-2"></i>
                        {{ $event->start_date->format('M d, Y') }}
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Event Details Section -->
<section class="section-padding">
    <div class="container">
        <div class="row">
            <!-- Event Main Content -->
            <div class="col-lg-8">
                <div class="card shadow-sm mb-5">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h2 class="mb-0">{{ $event->title }}</h2>
                            <span class="badge bg-{{ $event->supporters > 50 ? 'warning' : 'primary' }} fs-6">
                                {{ $event->supporters > 50 ? 'Limited Space' : 'Available' }}
                            </span>
                        </div>

                        <div class="event-meta mb-4">
                            <div class="d-flex flex-wrap gap-4">
                                <div class="d-flex align-items-center">
                                    <i class="far fa-calendar-alt me-2 text-primary fs-5"></i>
                                    <div>
                                        <h6 class="mb-0">Date & Time</h6>
                                        <p class="mb-0">
                                            {{ $event->start_date->format('l, F j, Y') }}<br>
                                            {{ $event->start_date->format('g:i A') }} - {{ $event->end_date->format('g:i A') }}
                                        </p>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center">
                                    <i class="fas fa-map-marker-alt me-2 text-primary fs-5"></i>
                                    <div>
                                        <h6 class="mb-0">Location</h6>
                                        <p class="mb-0">{{ $event->location }}</p>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center">
                                    <i class="fas fa-users me-2 text-primary fs-5"></i>
                                    <div>
                                        <h6 class="mb-0">Sponsors</h6>
                                        <p class="mb-0">{{ $event->supporters }} people sponsoring this event</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="event-description mb-5">
                            <h4 class="mb-3 border-bottom pb-2">About This Event</h4>
                            <div class="lead">{!! nl2br(e($event->description)) !!}</div>

                            @if($event->agenda)
                            <div class="mt-5">
                                <h4 class="mb-3 border-bottom pb-2">Event Agenda</h4>
                                <div class="timeline">
                                    @foreach($event->agenda as $item)
                                    <div class="timeline-item">
                                        <div class="timeline-badge">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                        <div class="timeline-panel">
                                            <div class="timeline-heading">
                                                <h5 class="mb-0">{{ $item['time'] }}</h5>
                                                @if(isset($item['duration']))
                                                <span class="badge bg-info">{{ $item['duration'] }}</span>
                                                @endif
                                            </div>
                                            <div class="timeline-body">
                                                <p class="mb-1 fw-bold">{{ $item['activity'] }}</p>
                                                @if(isset($item['speaker']))
                                                <p class="mb-0"><i class="fas fa-microphone me-2"></i>Speaker: {{ $item['speaker'] }}</p>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            @endif
                        </div>

                        <div class="event-actions d-flex gap-2 mb-4">
                            <button class="btn btn-primary support-event" data-event-id="{{ $event->id }}">
                                <i class="fas fa-thumbs-up me-2"></i>Sponsor This Event
                            </button>
                            <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#registrationModal">
                                <i class="fas fa-ticket-alt me-2"></i>Register Now
                            </button>
                        </div>

                        @if($event->organizer)
                        <div class="alert alert-light">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-user-tie fa-2x me-3 text-primary"></i>
                                <div>
                                    <h5 class="mb-1">Organized By</h5>
                                    <p class="mb-0">{{ $event->organizer }}</p>
                                    @if($event->organizer_contact)
                                    <p class="mb-0"><i class="fas fa-envelope me-2"></i>{{ $event->organizer_contact }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>

                @if($event->speakers)
                <section class="mb-5">
                    <div class="bg-light p-3 rounded shadow-sm mb-4">
                        <h4 class="mb-0">🌟 Featured Speakers</h4>
                    </div>

                    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-4">
                        @foreach($event->speakers as $speaker)
                        <div class="col">
                            <div class="card h-100 border-0 shadow-sm">
                                <div class="card-body d-flex align-items-start">
                                    <img
                                        src="{{ isset($speaker['photo']) && $speaker['photo'] ? asset('storage/' . $speaker['photo']) : asset('images/default-speaker.jpg') }}"
                                        alt="{{ $speaker['name'] ?? 'Speaker' }}"
                                        class="rounded-circle object-fit-cover me-3"
                                        style="width: 60px; height: 60px;">

                                    <div>
                                        <h6 class="card-title mb-1">{{ $speaker['name'] ?? 'Speaker Name' }}</h6>
                                        <p class="text-muted mb-1 small">{{ $speaker['title'] ?? 'Title' }}</p>
                                        <p class="card-text small mb-0 text-truncate" style="max-width: 250px;">
                                            {{ $speaker['bio'] ?? 'Short biography not available.' }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </section>
                @endif

                @if($event->gallery)
                <div class="card shadow-sm mb-5">
                    <div class="card-header bg-light">
                        <h4 class="mb-0">Event Gallery</h4>
                    </div>
                    <div class="card-body">
                        <div class="gallery-grid">
                            @foreach($event->gallery as $image)
                            <div class="gallery-item">
                                <a href="{{ asset('storage/' . $image) }}" data-lightbox="event-gallery">
                                    <img src="{{ asset('storage/' . $image) }}" alt="Event image" class="img-fluid">
                                </a>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endif

                <div class="card shadow-sm">
                    <div class="card-header bg-light">
                        <h4 class="mb-0">Location Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="map-container rounded overflow-hidden mb-3" style="height: 300px;">
                            <div id="event-map" style="height: 100%; width: 100%;"></div>
                        </div>
                        <p class="mb-0">
                            <i class="fas fa-info-circle me-2 text-primary"></i>
                            {{ $event->location_details ?? 'Detailed directions will be provided after registration.' }}
                        </p>

                        @if($event->registration_link)
                        <div class="mt-3">
                            <a href="{{ $event->registration_link }}" target="_blank" class="btn btn-outline-primary">
                                <i class="fas fa-external-link-alt me-2"></i>Official Registration Page
                            </a>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Event Sidebar -->
            <div class="col-lg-4">
                <!-- Registration Button Card - Fixed to stay below navbar -->
                <div class="card shadow-sm" style="top: 90px;">
                    <div class="card-header">
                        <h4 class="mb-0">Attend This Event</h4>
                    </div>
                    <div class="card-body text-center p-4">
                        <div class="mb-4">
                            <i class="fas fa-ticket-alt fa-3x text-primary mb-3"></i>
                            <h4>Register Now</h4>
                            <p class="text-muted">Secure your spot at this exclusive event</p>
                        </div>
                        <button class="btn btn-primary w-100 py-3" data-bs-toggle="modal" data-bs-target="#registrationModal">
                            <i class="fas fa-user-plus me-2"></i>Register for Event
                        </button>
                    </div>
                </div>
                <br><br>

                <div class="card shadow-sm mt-4">
                    <div class="card-header bg-light">
                        <h4 class="mb-0">Share This Event</h4>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-center gap-2">
                            <a href="#" class="btn btn-outline-primary">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="#" class="btn btn-outline-info">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="#" class="btn btn-outline-danger">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                            <a href="#" class="btn btn-outline-dark">
                                <i class="fas fa-envelope"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mt-4">
                    <div class="card-header bg-light">
                        <h4 class="mb-0">Other Upcoming Events</h4>
                    </div>
                    <div class="card-body">
                        <div class="list-group">
                            @foreach($otherEvents as $otherEvent)
                            <a href="{{ route('public.event.details', $otherEvent) }}"
                                class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">{{ $otherEvent->title }}</h6>
                                    <small>{{ $otherEvent->start_date->diffForHumans() }}</small>
                                </div>
                                <small class="text-muted">
                                    <i class="far fa-calendar me-1"></i>
                                    {{ $otherEvent->start_date->format('M d, Y') }}
                                </small>
                            </a>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Registration Modal -->
<div class="modal fade" id="registrationModal" tabindex="-1" aria-labelledby="registrationModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header card-header text-white">
                <h3 class="modal-title" id="registrationModalLabel">
                    <i class="fas fa-calendar-check me-2"></i>Register for {{ $event->title }}
                </h3>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <form action="{{ route('public.event.register') }}" method="POST">
                    @csrf
                    <input type="hidden" name="event_id" value="{{ $event->id }}">

                    @if (session('success'))
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle me-2"></i>
                        {{ session('success') }}
                    </div>
                    @endif

                    @if ($errors->any()))
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Please fix these issues:</strong>
                        <ul class="mt-2 mb-0">
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    <div class="mb-3">
                        <label class="form-label">Select Event</label>
                        <select name="event_id" class="form-select" required>
                            <option value="" selected disabled>Select an event</option>
                            @foreach($upcomingEvents as $event)
                            <option value="{{ $event->id }}">
                                {{ $event->title }} ({{ $event->start_date->format('M d') }})
                            </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Full Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" required value="{{ old('name') }}">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" name="email" class="form-control" required value="{{ old('email') }}">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Phone Number</label>
                            <input type="tel" name="phone" class="form-control" value="{{ old('phone') }}">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Organization (if applicable)</label>
                            <input type="text" name="organization" class="form-control" value="{{ old('organization') }}">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Attending as <span class="text-danger">*</span></label>
                        <select name="attending_as" class="form-select" required>
                            <option value="" selected disabled>Select your role</option>
                            <option value="Individual Citizen" {{ old('attending_as') == 'Individual Citizen' ? 'selected' : '' }}>Individual Citizen</option>
                            <option value="Business Representative" {{ old('attending_as') == 'Business Representative' ? 'selected' : '' }}>Business Representative</option>
                            <option value="NGO/Civil Society" {{ old('attending_as') == 'NGO/Civil Society' ? 'selected' : '' }}>NGO/Civil Society</option>
                            <option value="Government Official" {{ old('attending_as') == 'Government Official' ? 'selected' : '' }}>Government Official</option>
                            <option value="Legal Professional" {{ old('attending_as') == 'Legal Professional' ? 'selected' : '' }}>Legal Professional</option>
                            <option value="Academic/Researcher" {{ old('attending_as') == 'Academic/Researcher' ? 'selected' : '' }}>Academic/Researcher</option>
                            <option value="Media" {{ old('attending_as') == 'Media' ? 'selected' : '' }}>Media</option>
                        </select>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Special Requirements</label>
                        <textarea name="requirements" class="form-control" rows="2" placeholder="Accessibility needs, dietary restrictions, etc.">{{ old('requirements') }}</textarea>
                        <div class="form-text">We'll do our best to accommodate your needs</div>
                    </div>

                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-2"></i>Cancel
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check-circle me-2"></i>Complete Registration
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Google Maps Script -->
<script>
    function initMap() {
        // Geocode the event location
        const geocoder = new google.maps.Geocoder();
        const address = "{{ $event->location }}";

        geocoder.geocode({
            'address': address
        }, function(results, status) {
            if (status === 'OK') {
                // Create map centered at the event location
                const map = new google.maps.Map(document.getElementById('event-map'), {
                    zoom: 15,
                    center: results[0].geometry.location,
                    styles: [{
                            "featureType": "administrative",
                            "elementType": "labels.text.fill",
                            "stylers": [{
                                "color": "#444444"
                            }]
                        },
                        {
                            "featureType": "landscape",
                            "elementType": "all",
                            "stylers": [{
                                "color": "#f2f2f2"
                            }]
                        },
                        {
                            "featureType": "poi",
                            "elementType": "all",
                            "stylers": [{
                                "visibility": "off"
                            }]
                        },
                        {
                            "featureType": "road",
                            "elementType": "all",
                            "stylers": [{
                                    "saturation": -100
                                },
                                {
                                    "lightness": 45
                                }
                            ]
                        },
                        {
                            "featureType": "road.highway",
                            "elementType": "all",
                            "stylers": [{
                                "visibility": "simplified"
                            }]
                        },
                        {
                            "featureType": "road.arterial",
                            "elementType": "labels.icon",
                            "stylers": [{
                                "visibility": "off"
                            }]
                        },
                        {
                            "featureType": "transit",
                            "elementType": "all",
                            "stylers": [{
                                "visibility": "off"
                            }]
                        },
                        {
                            "featureType": "water",
                            "elementType": "all",
                            "stylers": [{
                                    "color": "#c7e0f4"
                                },
                                {
                                    "visibility": "on"
                                }
                            ]
                        }
                    ]
                });

                // Create marker for the event location
                new google.maps.Marker({
                    position: results[0].geometry.location,
                    map: map,
                    title: "{{ $event->title }}",
                    icon: {
                        url: "https://maps.google.com/mapfiles/ms/icons/red-dot.png",
                        scaledSize: new google.maps.Size(40, 40)
                    }
                });
            } else {
                console.error('Geocode was not successful: ' + status);
            }
        });
    }
</script>

<!-- Load Google Maps API -->
<script async defer
    src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}&callback=initMap">
</script>

<!-- Lightbox CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css">

<!-- Lightbox JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js"></script>

<style>
    /* Timeline styling - fixed alignment */
    .timeline {
        position: relative;
        padding-left: 40px;
        /* Increased padding for better alignment */
        margin-top: 20px;
    }

    .timeline-item {
        margin-bottom: 30px;
        position: relative;
    }

    .timeline-badge {
        position: absolute;
        left: -25px;
        /* Adjusted to center with increased padding */
        top: 0;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 100;
    }

    .timeline-panel {
        position: relative;
        background: #f8f9fa;
        border-radius: 6px;
        padding: 15px;
        border-left: 3px solid #0d6efd;
    }

    .timeline-heading {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }

    /* Gallery grid */
    .gallery-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
        gap: 10px;
    }

    .gallery-item {
        overflow: hidden;
        border-radius: 6px;
        aspect-ratio: 1/1;
    }

    .gallery-item img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }

    .gallery-item:hover img {
        transform: scale(1.05);
    }

    /* Fixed sticky sidebar position */
    /* .sticky-top {
        top: 90px !important;
        /* Position below navbar */
    /* z-index: 1020; */
    /* } */

    /* Ensure navbar doesn't overlap sticky elements */
    @media (min-width: 992px) {
        .navbar {
            height: 70px;
            /* Standardize navbar height */
        }
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .gallery-grid {
            grid-template-columns: repeat(3, 1fr);
        }

        .event-meta .d-flex {
            flex-direction: column;
            gap: 15px;
        }
    }

    @media (max-width: 576px) {
        .gallery-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .event-actions {
            flex-direction: column;
            gap: 10px;
        }

        .modal-content {
            margin: 10px;
        }

        /* Adjust timeline for mobile */
        .timeline {
            padding-left: 30px;
        }

        .timeline-badge {
            left: -15px;
        }
    }

    /* Modal styling */
    .modal-header {
        padding: 1.2rem 1.5rem;
    }

    .modal-title {
        font-size: 1.5rem;
    }

    .modal-body {
        padding: 1.5rem;
    }

    @media (max-width: 992px) {
        .modal-dialog {
            max-width: 95%;
        }
    }
</style>

@endsection