<!DOCTYPE html>
<html>

<head>
    <style>
        .email-container {
            max-width: 650px;
            margin: 0 auto;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .header {
            background-color: #1a365d;
            padding: 20px;
            color: white;
            border-bottom: 4px solid #c5a267;
        }

        .update-badge {
            background: #c5a267;
            color: #1a365d;
            padding: 5px 15px;
            border-radius: 20px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
        }

        .content {
            padding: 30px;
            background-color: #f8fafc;
        }

        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            overflow: hidden;
        }

        .field-group {
            display: flex;
            border-bottom: 1px solid #edf2f7;
            padding: 16px 20px;
        }

        .field-label {
            flex: 0 0 200px;
            color: #4a5568;
            font-weight: 600;
        }

        .field-value {
            flex: 1;
            color: #2d3748;
        }

        .status-active {
            color: #38a169;
            font-weight: 600;
        }

        .status-completed {
            color: #e53e3e;
            font-weight: 600;
        }

        .status-pending {
            color: #dd6b20;
            font-weight: 600;
        }

        .changes-highlight {
            background-color: #fffaf0;
            padding: 15px;
            border-left: 4px solid #dd6b20;
            margin: 20px 0;
        }

        .footer {
            text-align: center;
            padding: 20px;
            color: #718096;
            font-size: 0.9em;
            border-top: 1px solid #e2e8f0;
        }

        .action-link {
            display: inline-block;
            margin: 25px 0;
            padding: 12px 25px;
            background: #2b6cb0;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            font-weight: 600;
        }

        .updated-field {
            background-color: #ebf8ff;
            padding: 3px 6px;
            border-radius: 4px;
        }
    </style>
</head>

<body>
    <div class="email-container">
        <div class="header">
            <div class="update-badge">UPDATE NOTIFICATION</div>
            <h1 style="margin: 0; font-weight: 400;">Law Reform Project Modified</h1>
        </div>

        <div class="content">
            <div class="changes-highlight">
                <strong>Recent Updates:</strong> The following project details have been modified. Please review the updated information for accuracy.
            </div>

            <div class="card">
                <div class="field-group">
                    <div class="field-label">Project Title</div>
                    <div class="field-value">{{ $project->title }}</div>
                </div>

                <div class="field-group">
                    <div class="field-label">Description</div>
                    <div class="field-value">{{ $project->description }}</div>
                </div>

                <div class="field-group">
                    <div class="field-label">Focus Area</div>
                    <div class="field-value">
                        <span class="updated-field">{{ $project->focus_area }}</span>
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Status</div>
                    <div class="field-value status-{{ strtolower($project->status) }}">
                        <span class="updated-field">{{ $project->status }}</span>
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Timeline</div>
                    <div class="field-value">
                        {{ \Carbon\Carbon::parse($project->start_date)->format('M d, Y') }}
                        to
                        {{ \Carbon\Carbon::parse($project->end_date)->format('M d, Y') }}
                        <br>
                        <small>({{ \Carbon\Carbon::parse($project->start_date)->diffInDays($project->end_date) }} days duration)</small>
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Progress Report</div>
                    <div class="field-value">
                        {{ $project->progress_report }}
                        @php
                        $bgColor = $project->progress_report ? '#38a169' : '#e53e3e';
                        $statusText = $project->progress_report ? 'Submitted' : 'Pending';
                        @endphp
                        <div style="display: inline-block;
                                    padding: 3px 12px;
                                    border-radius: 12px;
                                    color: white;
                                    font-size: 0.85em;
                                    margin-top: 8px;">
                            {{ $statusText }}
                        </div>
                    </div>
                </div>

                <div class="field-group" style="border-bottom: none;">
                    <div class="field-label">Expected Outcomes</div>
                    <div class="field-value">{{ $project->outcomes }}</div>
                </div>
            </div>

            <p style="margin-top: 25px; line-height: 1.6;">
                The <strong>{{ $project->title }}</strong> project has been updated in the Law Reform Management System.
                The {{ $project->focus_area }} working group has been notified of these changes.
            </p>



            <div style="background-color: #f8f9fa; padding: 15px; border-radius: 8px; margin-top: 20px;">
                <p style="margin: 0; font-size: 0.95em; color: #4a5568;">
                    <strong>Last Updated:</strong> {{ now()->format('M j, Y \a\t g:i A') }}<br>
                    <!-- <strong>Next Review:</strong> {{ \Carbon\Carbon::parse($project->start_date)->addDays(14)->format('M d, Y') }}<br>
                    <strong>Project ID:</strong> LR-{{ str_pad($project->id, 6, '0', STR_PAD_LEFT) }} -->
                </p>
            </div>
        </div>

        <div class="footer">
            <p>© {{ date('Y') }} Law Reform Commission. All rights reserved.<br>
                This is an automated notification - please do not reply directly to this message.<br>
                Need assistance? Contact <a href="mailto:support@lawreform.org" style="color: #2b6cb0;">support@lawreform.org</a></p>
        </div>
    </div>
</body>

</html>