<!DOCTYPE html>
<html>

<head>
    <style>
        .email-container {
            max-width: 650px;
            margin: 0 auto;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .header {
            background-color: #1a365d;
            padding: 20px;
            color: white;
        }

        .header h1 {
            margin: 0;
            font-weight: 400;
        }

        .content {
            padding: 30px;
            background-color: #f8fafc;
        }

        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            overflow: hidden;
        }

        .field-group {
            display: flex;
            border-bottom: 1px solid #edf2f7;
            padding: 16px 20px;
        }

        .field-label {
            flex: 0 0 200px;
            color: #4a5568;
            font-weight: 600;
        }

        .field-value {
            flex: 1;
            color: #2d3748;
        }

        .status-active {
            color: #38a169;
            font-weight: 600;
        }

        .status-completed {
            color: #e53e3e;
            font-weight: 600;
        }

        .status-pending {
            color: #dd6b20;
            font-weight: 600;
        }

        .progress-bar {
            height: 8px;
            background: #e2e8f0;
            border-radius: 4px;
            margin-top: 6px;
        }

        .progress-fill {
            height: 100%;
            background: #4299e1;
            border-radius: 4px;
        }

        .footer {
            text-align: center;
            padding: 20px;
            color: #718096;
            font-size: 0.9em;
        }

        .action-link {
            display: inline-block;
            margin-top: 25px;
            padding: 12px 25px;
            background: #2b6cb0;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            font-weight: 600;
        }
    </style>
</head>

<body>
    <div class="email-container">
        <div class="header">
            <h1>Law Reform Project Initiated</h1>
        </div>

        <div class="content">
            <div class="card">
                <div class="field-group">
                    <div class="field-label">Project Title</div>
                    <div class="field-value">{{ $project->title }}</div>
                </div>

                <div class="field-group">
                    <div class="field-label">Description</div>
                    <div class="field-value">{{ $project->description }}</div>
                </div>

                <div class="field-group">
                    <div class="field-label">Focus Area</div>
                    <div class="field-value">{{ $project->focus_area }}</div>
                </div>

                <div class="field-group">
                    <div class="field-label">Status</div>
                    <div class="field-value status-{{ strtolower($project->status) }}">
                        {{ $project->status }}
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Timeline</div>
                    <div class="field-value">
                        {{ \Carbon\Carbon::parse($project->start_date)->format('M d, Y') }}
                        to
                        {{ \Carbon\Carbon::parse($project->end_date)->format('M d, Y') }}
                        <br>
                        <small>({{ \Carbon\Carbon::parse($project->start_date)->diffInDays($project->end_date) }} days duration)</small>
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Progress Report</div>
                    <div class="field-value">
                        {{ $project->progress_report }}
                        <!-- Status indicator instead of progress bar -->
                        @php
                        $bgColor = $project->progress_report ? '#38a169' : '#e53e3e';
                        $statusText = $project->progress_report ? 'Submitted' : 'Pending';
                        @endphp

                        <div class="status-pill"
                            style="display: inline-block;
                    padding: 3px 12px;
                    border-radius: 12px;
                    color: white;
                    font-size: 0.85em;
                    margin-top: 8px;">
                            {{ $statusText }}
                        </div>
                    </div>
                </div>

                <div class="field-group" style="border-bottom: none;">
                    <div class="field-label">Expected Outcomes</div>
                    <div class="field-value">{{ $project->outcomes }}</div>
                </div>
            </div>

            <p style="margin-top: 25px; line-height: 1.6;">
                This project has been successfully registered in the Legislative Management System.
                The {{ $project->focus_area }} working group will be notified automatically.
            </p>


            <p style="margin-top: 25px; font-size: 0.95em; color: #718096;">
                <strong>Next milestone:</strong> Draft review scheduled for
                {{ \Carbon\Carbon::parse($project->start_date)->addDays(14)->format('M d, Y') }}<br>
                <em>Project ID: LR-{{ str_pad($project->id, 6, '0', STR_PAD_LEFT) }}</em>
            </p>
        </div>

        <div class="footer">
            <p>© {{ date('Y') }} Law Reform Commission. All rights reserved.<br>
                This is an automated notification - please do not reply directly to this message.<br>
                Need assistance? Contact <a href="mailto:support@lawreform.org" style="color: #4299e1;">support@lawreform.org</a></p>
        </div>
    </div>
</body>

</html>