@extends('layouts.app')

@section('content')

<!-- Header Banner -->
<div class="banner-header valign bg-img bg-fixed" data-overlay-dark="5" data-background="{{ asset('storage/' . $siteSettings->breadcrumb) }}">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">
                <h6>
                    <div class="icon"><i class="flaticon-courthouse"></i></div> Get in touch
                </h6>
                <h1>Contact <span>Info</span></h1>
            </div>
        </div>
    </div>
</div>

<!-- Contact -->
<section class="info-box section-padding">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-courthouse"></i></div> Get in touch
                </div>
                <div class="section-title">Do you need help? <span>Contact with us now!</span></div>
                <div class="item"> <i class="icon fa-regular fa-location-dot"></i>
                    <div class="cont">
                        <h5>Address</h5>
                        <p>{{ $siteSettings->contact_address }}</p>
                    </div>
                </div>
                <div class="item"> <i class="icon fa-solid fa-phone"></i>
                    <div class="cont">
                        <h5>Phone</h5>
                        <p><a href="tel:{{ $siteSettings->contact_phone }}">{{ $siteSettings->contact_phone }}</a></p>
                    </div>
                </div>
                <div class="item"> <i class="icon fa-regular fa-envelope"></i>
                    <div class="cont">
                        <h5>e-Mail</h5>
                        <p>{{ $siteSettings->contact_email }}</p>
                    </div>
                </div>
                <div class="item">
                    <i class="icon fa-regular fa-clock"></i>
                    <div class="cont">
                        <h5>Business Hours</h5>
                        <p>{{ $siteSettings->business_hours }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-5 offset-md-1">
                <div class="contact-form">
                    <form method="POST" action="{{ route('contact.submit') }}">
                        @csrf
                        <h3>Contact with us <span>now!</span></h3>

                        @if (session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                        @endif

                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif

                        <div class="row">
                            <div class="col-md-12">
                                <input type="text" name="name" id="name" placeholder="Full Name" required value="{{ old('name') }}">
                            </div>
                            <div class="col-md-12">
                                <input type="email" name="email" id="email" placeholder="E-mail Address" required value="{{ old('email') }}">
                            </div>
                            <div class="col-md-12">
                                <textarea name="message" id="message" cols="40" rows="4" placeholder="Message" required>{{ old('message') }}</textarea>
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="button-3"><span>Send Message</span></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Map Section -->
<section class="map-section bg-light py-5">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center mb-5">
                <h2 class="section-title">Find Our <span>Location</span></h2>
                <p class="lead">Visit our office or get directions using the map below</p>
            </div>

            <div class="col-md-12">
                <div class="map-container shadow-lg rounded overflow-hidden">
                    <!-- Map will be rendered here -->
                    <div id="googleMap" style="height: 500px; width: 100%;"></div>

                    <div class="map-overlay bg-white p-4 rounded shadow-sm">
                        <h4 class="mb-3"><i class="fas fa-map-marker-alt text-primary me-2"></i> Our Office</h4>
                        <p class="mb-1"><strong>Address:</strong> {{ $siteSettings->contact_address }}</p>
                        <p class="mb-1"><strong>Phone:</strong> {{ $siteSettings->contact_phone }}</p>
                        <p class="mb-3"><strong>Email:</strong> {{ $siteSettings->contact_email }}</p>
                        <a href="https://www.google.com/maps/dir/?api=1&destination={{ urlencode($siteSettings->contact_address) }}"
                            target="_blank" class="btn btn-primary">
                            <i class="fas fa-directions me-2"></i> Get Directions
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Get in touch -->
<section class="call">
    <div class="background bg-img bg-fixed section-padding" data-background="{{ asset('storage/' . $siteSettings->breadcrumb) }}" data-overlay-dark="3">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-8 col-md-12">
                    <div class="section-title text-white mb-0">All people are equal before the law. <span>A good attorney</span> is what makes a difference.</div>
                </div>
                <div class="col-lg-3 offset-lg-1 col-md-12">
                    <div class="call-center">
                        <div class="icon"><i class="fa-solid fa-phone"></i></div>
                        <div class="text">
                            <p>Get in touch</p> <a href="tel:{{ $siteSettings->contact_phone }}">{{ $siteSettings->contact_phone }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Google Maps API Script -->
<script>
    function initMap() {
        // Geocode the address from site settings
        const geocoder = new google.maps.Geocoder();
        const address = "{{ $siteSettings->contact_address }}";

        geocoder.geocode({
            'address': address
        }, function(results, status) {
            if (status === 'OK') {
                // Get coordinates from geocoding result
                const location = results[0].geometry.location;

                // Create map centered at the address
                const map = new google.maps.Map(document.getElementById('googleMap'), {
                    zoom: 15,
                    center: location,
                    styles: [{
                            "featureType": "administrative",
                            "elementType": "labels.text.fill",
                            "stylers": [{
                                "color": "#444444"
                            }]
                        },
                        {
                            "featureType": "landscape",
                            "elementType": "all",
                            "stylers": [{
                                "color": "#f2f2f2"
                            }]
                        },
                        {
                            "featureType": "poi",
                            "elementType": "all",
                            "stylers": [{
                                "visibility": "off"
                            }]
                        },
                        {
                            "featureType": "road",
                            "elementType": "all",
                            "stylers": [{
                                    "saturation": -100
                                },
                                {
                                    "lightness": 45
                                }
                            ]
                        },
                        {
                            "featureType": "road.highway",
                            "elementType": "all",
                            "stylers": [{
                                "visibility": "simplified"
                            }]
                        },
                        {
                            "featureType": "road.arterial",
                            "elementType": "labels.icon",
                            "stylers": [{
                                "visibility": "off"
                            }]
                        },
                        {
                            "featureType": "transit",
                            "elementType": "all",
                            "stylers": [{
                                "visibility": "off"
                            }]
                        },
                        {
                            "featureType": "water",
                            "elementType": "all",
                            "stylers": [{
                                    "color": "#c7e0f4"
                                },
                                {
                                    "visibility": "on"
                                }
                            ]
                        }
                    ]
                });

                // Create marker for the location
                new google.maps.Marker({
                    position: location,
                    map: map,
                    title: "{{ $siteSettings->site_name }}",
                    icon: {
                        url: "https://maps.google.com/mapfiles/ms/icons/red-dot.png",
                        scaledSize: new google.maps.Size(40, 40)
                    }
                });

                // Create info window
                const infoWindow = new google.maps.InfoWindow({
                    content: `<div style="padding: 10px;">
                                <h5 style="margin: 0 0 5px; color: #1a365d;">{{ $siteSettings->site_name }}</h5>
                                <p style="margin: 0; font-size: 14px;">{{ $siteSettings->contact_address }}</p>
                              </div>`
                });

                // Open info window automatically
                infoWindow.open(map);

            } else {
                console.error('Geocode was not successful for the following reason: ' + status);
                // Fallback to a default location if geocoding fails
                const map = new google.maps.Map(document.getElementById('googleMap'), {
                    zoom: 4,
                    center: {
                        lat: 37.0902,
                        lng: -95.7129
                    } // Center of US
                });
            }
        });
    }
</script>

<!-- Load Google Maps API with your API key -->
<script async defer
    src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}&callback=initMap">
</script>

<style>
    /* Map Section Styles */
    .map-section {
        position: relative;
        z-index: 1;
    }

    .map-container {
        position: relative;
        height: 500px;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    }

    .map-overlay {
        position: absolute;
        bottom: 30px;
        left: 30px;
        background: white;
        padding: 25px;
        border-radius: 8px;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.15);
        max-width: 300px;
        z-index: 1000;
    }

    .map-overlay h4 {
        color: #1a365d;
        border-bottom: 2px solid #8e6d45;
        padding-bottom: 10px;
        margin-bottom: 15px;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .map-overlay {
            position: relative;
            bottom: auto;
            left: auto;
            max-width: 100%;
            margin-top: 20px;
        }

        .map-container {
            height: 400px;
        }
    }

    @media (max-width: 576px) {
        .map-container {
            height: 350px;
        }
    }
</style>

@endsection