<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('votes', function (Blueprint $table) {
            // Add poll_id if it doesn't exist
            if (!Schema::hasColumn('votes', 'poll_id')) {
                $table->foreignId('poll_id')->after('id')->constrained()->onDelete('cascade');
            }

            // Rename option_id if needed
            if (Schema::hasColumn('votes', 'poll_option_id')) {
                $table->renameColumn('poll_option_id', 'option_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('votes', function (Blueprint $table) {
            $table->dropForeign(['poll_id']);
            $table->dropColumn('poll_id');
            $table->renameColumn('option_id', 'poll_option_id');
        });
    }
};
