<?php

namespace App\Policies;

use App\Models\ReformProject;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class ReformProjectPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        if ($user->hasPermissionTo('view reforms')) {
            return true;
        }
        return false;
        // return false;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, ReformProject $reformProject): bool
    {
        return false;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        if ($user->hasPermissionTo('create reform')) {
            return true;
        }
        return false;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, ReformProject $reformProject): bool
    {
        if ($user->hasPermissionTo('update reform')) {
            return true;
        }
        return false;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, ReformProject $reformProject): bool
    {
        if ($user->hasPermissionTo('delete reform')) {
            return true;
        }
        return false;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, ReformProject $reformProject): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, ReformProject $reformProject): bool
    {
        return false;
    }
}
