<?php

namespace App\Observers;

use App\Mail\NewLawReformProjectNotification;
use App\Mail\UpdateLawReformProjectNotification;
use App\Models\LawReformProject;
use App\Models\ReformProject;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class LawReformProjectObserver
{
    /**
     * Handle the LawReformProject "created" event.
     */
    public function created(ReformProject $project): void
    {
        // Create the project

        // Send mail to admin and user who created the project
        // Mail::to('support@lawreform.com')
        //     ->cc($project->user->email) // Assuming the project has a 'user' relationship
        //     ->send(new NewLawReformProjectNotification($project));

        // Mail::to('admin@example.com')->send(new NewLawReformProjectNotification($project));
        // Mail::to($project->user->email)->send(new NewLawReformProjectNotification($project));
    }

    /**
     * Handle the LawReformProject "updated" event.
     */
    public function updated(ReformProject $project): void
    {
        Mail::to('support@lawreform.com')
            ->cc($project->user->email) // Assuming the project has a 'user' relationship
            ->send(new UpdateLawReformProjectNotification($project));
    }

    /**
     * Handle the LawReformProject "deleted" event.
     */
    public function deleted(ReformProject $lawReformProject): void
    {
        //
    }

    /**
     * Handle the LawReformProject "restored" event.
     */
    public function restored(ReformProject $lawReformProject): void
    {
        //
    }

    /**
     * Handle the LawReformProject "force deleted" event.
     */
    public function forceDeleted(ReformProject $lawReformProject): void
    {
        //
    }
}
