<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReformProject extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'focus_area',
        'status',
        'start_date',
        'end_date',
        'progress_report',
        'outcomes',
        'user_id',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
