<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Publication extends Model
{
      use HasFactory;

      protected $fillable = [
            'title',
            'type',
            'file_upload',
            'description',
            'published_date',
      ];

      protected $casts = [
            'published_date' => 'date',
      ];

      protected $guarded = [];

      public function getPublicPath()
      {
            return storage_path('app/public/publications/' . basename($this->file_path));
      }

      public function user()
      {
            return $this->belongsTo(User::class);
      }
}
