<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LawReform extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'document_path',
        'effective_date',
        'is_active'
    ];

    // Cast effective_date to Carbon instance
    protected $casts = [
        'effective_date' => 'date',
    ];

    public function getRouteKeyName()
    {
        return 'id'; // or 'id' if you're not using slugs
    }
}
