<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InfluentialPoll extends Model
{
    protected $fillable = [
        'title',
        'impact_description',
        'impact_level',
        'result',
        'poll_id'
    ];

    /**
     * Get the poll associated with the influential poll.
     */
    public function poll(): BelongsTo
    {
        return $this->belongsTo(Poll::class);
    }
}
