<?php

namespace App\Http\Controllers;

use App\Mail\NewLawReformProjectNotification;
use App\Models\LawReform;
use App\Models\ReformProject;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class LawReformController extends Controller
{
    public function index()
    {
        $reforms = ReformProject::latest()->paginate(10);
        return view('law-reforms.index', compact('reforms'));
    }

    public function show(ReformProject $law_reform)
    {
        return view('law-reforms.show', compact('law_reform'));
    }
}
