<?php

namespace App\Http\Controllers;

use App\Models\Event;
use App\Models\SiteSetting;
use Illuminate\Http\Request;

class EventController extends Controller
{
    public function show(Event $event)
    {
        $upcomingEvents = Event::where('end_date', '>', now())
            ->where('is_published', true)
            ->orderBy('end_date')
            ->get()
            ->each(function ($event) {
                $event->date_time = $event->start_date->format('F j, Y | h:i A');
                $event->status = $event->supporters > 50 ? 'Limited Space' : 'Available';
                $event->status_color = $event->supporters > 50 ? 'warning' : 'primary';
            });

        $otherEvents = Event::where('id', '!=', $event->id)
            ->where('start_date', '>', now())
            ->orderBy('start_date')
            ->take(5)
            ->get();

        return view('event-details', [
            'event' => $event,
            'otherEvents' => $otherEvents,
            'upcomingEvents' => $upcomingEvents,
            'siteSettings' => SiteSetting::first(), // Or your site settings retrieval method
        ]);
    }
}
