<?php

namespace App\Filament\Resources\NewsResource\Pages;

use App\Filament\Resources\NewsResource;
use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;

class CreateNews extends CreateRecord
{
    protected static string $resource = NewsResource::class;

    protected function getRedirectUrl(): string
    {
        return $this->previousUrl;
    }
    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()->success()->title("News Created.")->body('The News Created Successfully');
    }
}
