<?php

namespace App\Filament\Resources;

use App\Filament\Resources\EventRegistrationResource\Pages;
use App\Filament\Resources\EventRegisterationResource\RelationManagers;
use App\Models\EventRegisteration;
use App\Models\EventRegistration;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class EventRegistrationResource extends Resource
{
    protected static ?string $model = EventRegistration::class;

    protected static ?string $navigationGroup = 'Public Engagement';
    protected static ?string $navigationIcon = 'heroicon-o-users';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('event_id')
                    ->relationship('event', 'title')
                    ->required()
                    ->label('Event'),

                Forms\Components\TextInput::make('name')
                    ->required()
                    ->maxLength(255),

                Forms\Components\TextInput::make('email')
                    ->email()
                    ->required()
                    ->maxLength(255),

                Forms\Components\TextInput::make('organization')
                    ->maxLength(255),

                Forms\Components\Select::make('attending_as')
                    ->label('Attending As')
                    ->options([
                        'individual_citizen' => 'Individual Citizen',
                        'business_representative' => 'Business Representative',
                        'ngo_civil_society' => 'NGO/Civil Society',
                        'government_official' => 'Government Official',
                        'legal_professional' => 'Legal Professional',
                        'academic_researcher' => 'Academic/Researcher',
                        'media' => 'Media',
                    ])
                    ->required()
                    ->placeholder('Select your role'),

                Forms\Components\Textarea::make('requirements')
                    ->label('Special Requirements')
                    ->rows(3)
                    ->maxLength(500),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('event.title')->label('Event'),
                Tables\Columns\TextColumn::make('name')->searchable(),
                Tables\Columns\TextColumn::make('email'),
                Tables\Columns\TextColumn::make('organization')->limit(20),
                Tables\Columns\TextColumn::make('attending_as')->label('Attending As'),
                Tables\Columns\TextColumn::make('created_at')->dateTime('M d, Y h:i A')->label('Registered At'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListEventRegistrations::route('/'),
            'create' => Pages\CreateEventRegistration::route('/create'),
            'edit' => Pages\EditEventRegistration::route('/{record}/edit'),
        ];
    }
}
